import ContactForm from '@/components/ContactForm'
import InsuranceCalculator from '@/components/InsuranceCalculator'
import { Metadata } from 'next'

export const metadata: Metadata = {
  title: 'Free Auto Insurance Quotes - Compare & Save up to $500 | SecureAuto Hub',
  description: 'Get free auto insurance quotes from 50+ top insurers. Use our calculator for instant estimates. Compare rates, save money, and find the perfect coverage.',
  keywords: [
    'free auto insurance quotes',
    'car insurance quotes online',
    'compare auto insurance rates',
    'insurance calculator',
    'cheap car insurance quotes',
    'auto insurance comparison'
  ],
  openGraph: {
    title: 'Free Auto Insurance Quotes - Compare & Save up to $500',
    description: 'Get personalized auto insurance quotes from top insurers. Use our free calculator and save hundreds on your premiums.',
    type: 'website',
  },
}

export default function QuotePage() {
  const benefits = [
    'Compare rates from 50+ top insurers',
    'Get personalized recommendations',
    'No hidden fees or charges',
    'Expert guidance throughout the process',
    'Instant online quotes available',
    'Free consultation with no obligation'
  ]

  return (
    <div className="min-h-screen bg-gray-50">
      {/* Hero Section */}
      <div className="bg-gradient-to-br from-blue-600 to-blue-800 text-white py-16">
        <div className="max-w-6xl mx-auto px-4 text-center">
          <h1 className="text-5xl font-bold mb-6">Get Your Free Auto Insurance Quote</h1>
          <p className="text-xl max-w-3xl mx-auto">
            Compare personalized quotes from top insurance providers and save up to $500 per year on your auto insurance.
          </p>
        </div>
      </div>

      {/* Benefits Section */}
      <div className="py-12 bg-white">
        <div className="max-w-6xl mx-auto px-4">
          <div className="text-center mb-8">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">Why Get a Quote with SecureAuto Hub?</h2>
          </div>
          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
            {benefits.map((benefit, index) => (
              <div key={index} className="flex items-center space-x-3">
                <div className="flex-shrink-0 w-6 h-6 bg-green-100 rounded-full flex items-center justify-center">
                  <svg className="w-4 h-4 text-green-600" fill="currentColor" viewBox="0 0 20 20">
                    <path fillRule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clipRule="evenodd" />
                  </svg>
                </div>
                <span className="text-gray-700">{benefit}</span>
              </div>
            ))}
          </div>
        </div>
      </div>

      {/* Calculator Section */}
      <div className="py-16">
        <div className="max-w-4xl mx-auto px-4">
          <div className="text-center mb-8">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">
              Step 1: Get an Instant Estimate
            </h2>
            <p className="text-gray-600">
              Use our calculator to get a ballpark estimate of your insurance costs
            </p>
          </div>
          <InsuranceCalculator />
        </div>
      </div>

      {/* Quote Form Section */}
      <div className="py-16 bg-white">
        <div className="max-w-4xl mx-auto px-4">
          <div className="text-center mb-8">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">
              Step 2: Get Your Personalized Quote
            </h2>
            <p className="text-gray-600">
              Fill out this form to receive detailed quotes from multiple insurance providers
            </p>
          </div>
          <ContactForm title="Request Your Free Quote" isQuoteForm={true} />
        </div>
      </div>

      {/* Process Section */}
      <div className="py-16 bg-gray-50">
        <div className="max-w-6xl mx-auto px-4">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">How It Works</h2>
            <p className="text-gray-600">Get your quote in three simple steps</p>
          </div>

          <div className="grid md:grid-cols-3 gap-8">
            <div className="text-center">
              <div className="bg-blue-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                <span className="text-2xl font-bold text-blue-600">1</span>
              </div>
              <h3 className="text-xl font-semibold text-gray-900 mb-3">Tell Us About You</h3>
              <p className="text-gray-600">
                Share basic information about yourself, your vehicle, and your coverage needs
              </p>
            </div>

            <div className="text-center">
              <div className="bg-blue-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                <span className="text-2xl font-bold text-blue-600">2</span>
              </div>
              <h3 className="text-xl font-semibold text-gray-900 mb-3">Compare Quotes</h3>
              <p className="text-gray-600">
                We'll present you with personalized quotes from multiple top-rated insurance providers
              </p>
            </div>

            <div className="text-center">
              <div className="bg-blue-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                <span className="text-2xl font-bold text-blue-600">3</span>
              </div>
              <h3 className="text-xl font-semibold text-gray-900 mb-3">Choose & Save</h3>
              <p className="text-gray-600">
                Select the best coverage for your needs and start saving on your auto insurance
              </p>
            </div>
          </div>
        </div>
      </div>

      {/* FAQ Section */}
      <div className="py-16 bg-white">
        <div className="max-w-4xl mx-auto px-4">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">Frequently Asked Questions</h2>
          </div>

          <div className="space-y-6">
            <div className="bg-gray-50 rounded-lg p-6">
              <h3 className="text-lg font-semibold text-gray-900 mb-2">
                Is it really free to get a quote?
              </h3>
              <p className="text-gray-600">
                Yes! Getting a quote is completely free with no obligation to purchase. We never charge fees for quotes or consultations.
              </p>
            </div>

            <div className="bg-gray-50 rounded-lg p-6">
              <h3 className="text-lg font-semibold text-gray-900 mb-2">
                How long does it take to get my quotes?
              </h3>
              <p className="text-gray-600">
                Most quotes are available instantly online. For more complex situations, we'll have your personalized quotes within 24 hours.
              </p>
            </div>

            <div className="bg-gray-50 rounded-lg p-6">
              <h3 className="text-lg font-semibold text-gray-900 mb-2">
                Will getting a quote affect my credit score?
              </h3>
              <p className="text-gray-600">
                No, requesting insurance quotes does not impact your credit score. We use soft credit inquiries that don't affect your credit rating.
              </p>
            </div>
          </div>
        </div>
      </div>
    </div>
  )
}
