import type { Metadata } from "next";
import { Inter } from "next/font/google";
import "./globals.css";

const inter = Inter({
  subsets: ["latin"],
  variable: "--font-inter",
});

export const metadata: Metadata = {
  metadataBase: new URL('https://same-tcxcd5b572d-latest.netlify.app'),
  title: {
    default: 'SecureAuto Hub - Complete Auto Insurance Solutions & Expert Guidance',
    template: '%s | SecureAuto Hub'
  },
  description: 'SecureAuto Hub - Your premier source for comprehensive auto insurance guidance and protection. Compare quotes from 50+ top insurers, use our insurance calculator, and get expert advice. Save up to $500 annually.',
  keywords: [
    'auto insurance',
    'car insurance quotes',
    'insurance calculator',
    'compare insurance rates',
    'auto insurance coverage',
    'insurance quotes online',
    'cheap car insurance',
    'vehicle insurance',
    'insurance comparison',
    'auto insurance tips'
  ],
  authors: [{ name: 'SecureAuto Hub Team' }],
  creator: 'SecureAuto Hub',
  publisher: 'SecureAuto Hub',
  robots: {
    index: true,
    follow: true,
    googleBot: {
      index: true,
      follow: true,
      'max-video-preview': -1,
      'max-image-preview': 'large',
      'max-snippet': -1,
    },
  },
  openGraph: {
    type: 'website',
    locale: 'en_US',
    url: 'https://same-tcxcd5b572d-latest.netlify.app',
    siteName: 'SecureAuto Hub',
    title: 'SecureAuto Hub - Complete Auto Insurance Solutions',
    description: 'Compare auto insurance quotes from 50+ top insurers. Use our free calculator, get expert guidance, and save up to $500 annually on your auto insurance.',
    images: [
      {
        url: '/og-image.jpg',
        width: 1200,
        height: 630,
        alt: 'SecureAuto Hub - Auto Insurance Solutions',
      },
    ],
  },
  twitter: {
    card: 'summary_large_image',
    title: 'SecureAuto Hub - Complete Auto Insurance Solutions',
    description: 'Compare auto insurance quotes from 50+ top insurers. Free calculator, expert guidance, save up to $500 annually.',
    images: ['/og-image.jpg'],
    creator: '@secureautohub',
  },
  verification: {
    google: 'your-google-verification-code',
    yandex: 'your-yandex-verification-code',
    yahoo: 'your-yahoo-verification-code',
  },
  category: 'Insurance',
  classification: 'Auto Insurance Services',
  alternates: {
    canonical: 'https://same-tcxcd5b572d-latest.netlify.app',
  },
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  const jsonLd = {
    '@context': 'https://schema.org',
    '@type': 'Organization',
    name: 'SecureAuto Hub',
    description: 'Premier auto insurance comparison and guidance platform helping drivers find the perfect coverage.',
    url: 'https://same-tcxcd5b572d-latest.netlify.app',
    logo: 'https://same-tcxcd5b572d-latest.netlify.app/logo.png',
    image: 'https://same-tcxcd5b572d-latest.netlify.app/og-image.jpg',
    telephone: '+1-512-555-0199',
    email: 'hello@secureautohub.com',
    address: {
      '@type': 'PostalAddress',
      streetAddress: '2847 Innovation Drive #425',
      addressLocality: 'Austin',
      addressRegion: 'TX',
      postalCode: '78749',
      addressCountry: 'US'
    },
    contactPoint: {
      '@type': 'ContactPoint',
      telephone: '+1-512-555-0199',
      contactType: 'Customer Service',
      availableLanguage: ['English'],
      hoursAvailable: {
        '@type': 'OpeningHoursSpecification',
        dayOfWeek: ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday'],
        opens: '08:00',
        closes: '20:00'
      }
    },
    sameAs: [
      'https://www.facebook.com/secureautohub',
      'https://www.twitter.com/secureautohub',
      'https://www.linkedin.com/company/secureautohub'
    ],
    founder: {
      '@type': 'Person',
      name: 'Sarah Johnson',
      jobTitle: 'Founder & CEO'
    },
    areaServed: {
      '@type': 'Country',
      name: 'United States'
    },
    hasOfferCatalog: {
      '@type': 'OfferCatalog',
      name: 'Auto Insurance Services',
      itemListElement: [
        {
          '@type': 'Offer',
          itemOffered: {
            '@type': 'Service',
            name: 'Auto Insurance Quotes',
            description: 'Free personalized auto insurance quotes from top providers'
          }
        },
        {
          '@type': 'Offer',
          itemOffered: {
            '@type': 'Service',
            name: 'Insurance Calculator',
            description: 'Interactive auto insurance premium calculator'
          }
        },
        {
          '@type': 'Offer',
          itemOffered: {
            '@type': 'Service',
            name: 'Expert Consultation',
            description: 'Professional insurance guidance and advice'
          }
        }
      ]
    }
  };

  return (
    <html lang="en">
      <head>
        <script
          type="application/ld+json"
          dangerouslySetInnerHTML={{ __html: JSON.stringify(jsonLd) }}
        />
        <link rel="canonical" href="https://same-tcxcd5b572d-latest.netlify.app" />
        <meta name="geo.region" content="US" />
        <meta name="geo.placename" content="Austin, Texas" />
        <meta name="geo.position" content="30.2672;-97.7431" />
        <meta name="ICBM" content="30.2672, -97.7431" />
        <meta name="theme-color" content="#2563eb" />
        <meta name="mobile-web-app-capable" content="yes" />
        <meta name="apple-mobile-web-app-capable" content="yes" />
        <meta name="apple-mobile-web-app-status-bar-style" content="default" />
        <meta name="apple-mobile-web-app-title" content="SecureAuto Hub" />
        <link rel="apple-touch-icon" href="/apple-touch-icon.png" />
        <link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png" />
        <link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png" />
        <link rel="manifest" href="/site.webmanifest" />
      </head>
      <body
        className={`${inter.variable} font-sans antialiased`}
      >
        {children}
      </body>
    </html>
  );
}
