import Image from 'next/image'
import { Metadata } from 'next'

export const metadata: Metadata = {
  title: 'About SecureAuto Hub - Expert Auto Insurance Team & Company Story',
  description: 'Learn about SecureAuto Hub\'s expert team, company values, and mission to simplify auto insurance. Founded by industry veterans with 15+ years experience.',
  keywords: [
    'about SecureAuto Hub',
    'auto insurance experts',
    'insurance company team',
    'auto insurance professionals',
    'insurance guidance specialists'
  ],
  openGraph: {
    title: 'About SecureAuto Hub - Expert Auto Insurance Team',
    description: 'Meet our expert team and learn about our mission to simplify auto insurance for everyone.',
    type: 'website',
  },
}

export default function AboutPage() {
  const teamMembers = [
    {
      name: 'Sarah Johnson',
      role: 'Founder & CEO',
      description: 'With 15 years in insurance, Sarah founded SecureAuto Hub to simplify the insurance experience for everyone.',
      image: 'https://images.unsplash.com/photo-1494790108755-2616b612b47c?w=300&h=300&fit=crop&crop=face'
    },
    {
      name: 'Michael Chen',
      role: 'Head of Customer Relations',
      description: 'Michael ensures every customer receives personalized service and finds the perfect coverage for their needs.',
      image: 'https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?w=300&h=300&fit=crop&crop=face'
    },
    {
      name: 'Emily Rodriguez',
      role: 'Insurance Specialist',
      description: 'Emily\'s expertise in policy analysis helps customers understand complex insurance terms and make informed decisions.',
      image: 'https://images.unsplash.com/photo-1580489944761-15a19d654956?w=300&h=300&fit=crop&crop=face'
    }
  ]

  const values = [
    {
      title: 'Transparency',
      description: 'We believe in clear, honest communication about coverage options, pricing, and terms.',
      icon: '🔍'
    },
    {
      title: 'Customer-First',
      description: 'Every decision we make prioritizes our customers\' best interests and long-term satisfaction.',
      icon: '❤️'
    },
    {
      title: 'Expert Guidance',
      description: 'Our team provides knowledgeable advice to help you make informed insurance decisions.',
      icon: '🎓'
    },
    {
      title: 'Innovation',
      description: 'We continuously improve our tools and services to enhance your insurance experience.',
      icon: '🚀'
    }
  ]

  return (
    <div className="min-h-screen">
      {/* Hero Section */}
      <div className="bg-gradient-to-br from-blue-600 to-blue-800 text-white py-20">
        <div className="max-w-6xl mx-auto px-4">
          <div className="text-center">
            <h1 className="text-5xl font-bold mb-6">About SecureAuto Hub</h1>
            <p className="text-xl max-w-3xl mx-auto leading-relaxed">
              We're dedicated to transforming the auto insurance experience through transparency,
              expert guidance, and innovative solutions tailored to your unique needs.
            </p>
          </div>
        </div>
      </div>

      {/* Our Story */}
      <div className="py-20 bg-white">
        <div className="max-w-6xl mx-auto px-4">
          <div className="grid lg:grid-cols-2 gap-12 items-center">
            <div>
              <h2 className="text-4xl font-bold text-gray-900 mb-6">Our Story</h2>
              <div className="space-y-4 text-gray-600 leading-relaxed">
                <p>
                  Founded in 2020, SecureAuto Hub emerged from a simple observation: auto insurance
                  was unnecessarily complicated and often left customers confused about their coverage
                  options. Our founders, with decades of combined experience in the insurance industry,
                  set out to change that.
                </p>
                <p>
                  We started with a mission to demystify auto insurance by providing clear,
                  comprehensive information and personalized guidance. Today, we've helped thousands
                  of drivers find the right coverage at the right price, building lasting relationships
                  based on trust and transparency.
                </p>
                <p>
                  Our commitment goes beyond just finding you insurance – we're here to educate,
                  support, and advocate for you throughout your entire insurance journey.
                </p>
              </div>
            </div>
            <div>
              <Image
                src="https://images.unsplash.com/photo-1600880292203-757bb62b4baf?w=600&h=400&fit=crop"
                alt="Our office and team"
                width={600}
                height={400}
                className="rounded-lg shadow-lg"
              />
            </div>
          </div>
        </div>
      </div>

      {/* Our Values */}
      <div className="py-20 bg-gray-50">
        <div className="max-w-6xl mx-auto px-4">
          <div className="text-center mb-16">
            <h2 className="text-4xl font-bold text-gray-900 mb-4">Our Values</h2>
            <p className="text-xl text-gray-600 max-w-2xl mx-auto">
              These core principles guide everything we do and every interaction we have
            </p>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
            {values.map((value, index) => (
              <div key={index} className="bg-white rounded-lg p-8 shadow-md text-center">
                <div className="text-4xl mb-4">{value.icon}</div>
                <h3 className="text-xl font-bold text-gray-900 mb-3">{value.title}</h3>
                <p className="text-gray-600 leading-relaxed">{value.description}</p>
              </div>
            ))}
          </div>
        </div>
      </div>

      {/* Our Team */}
      <div className="py-20 bg-white">
        <div className="max-w-6xl mx-auto px-4">
          <div className="text-center mb-16">
            <h2 className="text-4xl font-bold text-gray-900 mb-4">Meet Our Team</h2>
            <p className="text-xl text-gray-600 max-w-2xl mx-auto">
              Get to know the dedicated professionals working to serve you better
            </p>
          </div>

          <div className="grid md:grid-cols-3 gap-8">
            {teamMembers.map((member, index) => (
              <div key={index} className="text-center">
                <div className="relative mb-6">
                  <Image
                    src={member.image}
                    alt={member.name}
                    width={200}
                    height={200}
                    className="rounded-full mx-auto shadow-lg"
                  />
                </div>
                <h3 className="text-xl font-bold text-gray-900 mb-2">{member.name}</h3>
                <p className="text-blue-600 font-semibold mb-3">{member.role}</p>
                <p className="text-gray-600 leading-relaxed">{member.description}</p>
              </div>
            ))}
          </div>
        </div>
      </div>

      {/* Stats */}
      <div className="py-20 bg-blue-600 text-white">
        <div className="max-w-6xl mx-auto px-4">
          <div className="grid md:grid-cols-4 gap-8 text-center">
            <div>
              <div className="text-4xl font-bold mb-2">10,000+</div>
              <div className="text-blue-100">Happy Customers</div>
            </div>
            <div>
              <div className="text-4xl font-bold mb-2">50+</div>
              <div className="text-blue-100">Insurance Partners</div>
            </div>
            <div>
              <div className="text-4xl font-bold mb-2">98%</div>
              <div className="text-blue-100">Satisfaction Rate</div>
            </div>
            <div>
              <div className="text-4xl font-bold mb-2">24/7</div>
              <div className="text-blue-100">Customer Support</div>
            </div>
          </div>
        </div>
      </div>

      {/* CTA Section */}
      <div className="py-20 bg-gray-50">
        <div className="max-w-4xl mx-auto px-4 text-center">
          <h2 className="text-4xl font-bold text-gray-900 mb-6">
            Ready to Experience the SecureAuto Hub Difference?
          </h2>
          <p className="text-xl text-gray-600 mb-8">
            Join thousands of satisfied customers who trust us with their auto insurance needs
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <a
              href="/quote"
              className="bg-blue-600 text-white px-8 py-3 rounded-lg font-semibold hover:bg-blue-700 transition-colors"
            >
              Get Your Free Quote
            </a>
            <a
              href="/contact"
              className="bg-white text-blue-600 border border-blue-600 px-8 py-3 rounded-lg font-semibold hover:bg-blue-50 transition-colors"
            >
              Contact Our Team
            </a>
          </div>
        </div>
      </div>
    </div>
  )
}
