'use client'

import Image from 'next/image'
import Link from 'next/link'
import { useState } from 'react'

export default function Home() {
  const [isMenuOpen, setIsMenuOpen] = useState(false)

  return (
    <div className="min-h-screen">
      {/* Navigation */}
      <nav className="bg-white border-b border-gray-200">
        <div className="max-w-6xl mx-auto px-4">
          <div className="flex justify-between items-center py-4">
            <div className="flex items-center">
              <Link href="/" className="text-2xl font-bold text-gray-800">
                <span className="text-blue-600">SecureAuto</span> Hub
              </Link>
            </div>

            {/* Desktop Menu */}
            <div className="hidden md:flex space-x-8">
              <Link href="/" className="text-gray-700 hover:text-gray-900 font-medium">Home</Link>
              <Link href="/about" className="text-gray-700 hover:text-gray-900 font-medium">About Us</Link>
              <Link href="/faq" className="text-gray-700 hover:text-gray-900 font-medium">FAQ</Link>
              <Link href="/quote" className="text-gray-700 hover:text-gray-900 font-medium">Get Quote</Link>
              <Link href="/blog" className="text-gray-700 hover:text-gray-900 font-medium">Blog</Link>
              <Link href="/contact" className="text-gray-700 hover:text-gray-900 font-medium">Contact Us</Link>
            </div>

            {/* Mobile Menu Button */}
            <button
              className="md:hidden p-2"
              onClick={() => setIsMenuOpen(!isMenuOpen)}
              aria-label="Toggle menu"
            >
              <div className="w-6 h-6 flex flex-col justify-around">
                <span className={`block h-0.5 w-6 bg-gray-600 transition-all duration-300 ${isMenuOpen ? 'rotate-45 translate-y-2.5' : ''}`}></span>
                <span className={`block h-0.5 w-6 bg-gray-600 transition-all duration-300 ${isMenuOpen ? 'opacity-0' : ''}`}></span>
                <span className={`block h-0.5 w-6 bg-gray-600 transition-all duration-300 ${isMenuOpen ? '-rotate-45 -translate-y-2.5' : ''}`}></span>
              </div>
            </button>
          </div>

          {/* Mobile Menu */}
          <div className={`md:hidden transition-all duration-300 ease-in-out ${isMenuOpen ? 'max-h-96 pb-4' : 'max-h-0 overflow-hidden'}`}>
            <div className="flex flex-col space-y-3">
              <Link href="/" className="text-gray-700 hover:text-gray-900 font-medium py-2">Home</Link>
              <Link href="/about" className="text-gray-700 hover:text-gray-900 font-medium py-2">About Us</Link>
              <Link href="/faq" className="text-gray-700 hover:text-gray-900 font-medium py-2">FAQ</Link>
              <Link href="/quote" className="text-gray-700 hover:text-gray-900 font-medium py-2">Get Quote</Link>
              <Link href="/blog" className="text-gray-700 hover:text-gray-900 font-medium py-2">Blog</Link>
              <Link href="/contact" className="text-gray-700 hover:text-gray-900 font-medium py-2">Contact Us</Link>
            </div>
          </div>
        </div>
      </nav>

      {/* Hero Section */}
      <div className="relative py-20 min-h-[500px] bg-gray-400 overflow-hidden">
        <Image
          src="https://static.vecteezy.com/system/resources/previews/037/146/976/non_2x/close-up-on-blue-car-toy-model-in-hands-protection-for-car-insurance-concept-free-photo.JPG"
          alt="Hero Background"
          fill
          className="object-cover"
          priority
        />
        <div className="absolute inset-0 hero-overlay"></div>
        <div className="relative max-w-6xl mx-auto px-4 z-10">
          <div className="flex justify-center">
            <div className="w-full md:w-2/3 lg:w-1/2">
              <div className="bg-white rounded-lg p-8 shadow-lg">
                <h1 className="text-4xl font-bold text-gray-900 mb-4">
                  MAXIMIZE PROTECTION:
                </h1>
                <h2 className="text-2xl text-gray-700 mb-6">
                  Your Complete Auto Insurance Solution
                </h2>
                <p className="text-gray-600 leading-relaxed mb-6">
                  Discover your trusted destination for comprehensive auto insurance guidance and protection. We specialize in helping drivers find the perfect coverage that fits their lifestyle and budget. Our expert resources and personalized approach make securing reliable auto insurance straightforward and stress-free.
                </p>
                <div className="flex flex-col sm:flex-row gap-4">
                  <Link
                    href="/quote"
                    className="bg-blue-600 text-white px-6 py-3 rounded-lg font-semibold hover:bg-blue-700 transition-colors text-center"
                  >
                    Get Free Quote
                  </Link>
                  <Link
                    href="/quote#calculator"
                    className="bg-white text-blue-600 border border-blue-600 px-6 py-3 rounded-lg font-semibold hover:bg-blue-50 transition-colors text-center"
                  >
                    Try Calculator
                  </Link>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      {/* About Us Section */}
      <div className="py-20 bg-white">
        <div className="max-w-6xl mx-auto px-4">
          <div className="grid md:grid-cols-2 gap-12 items-center">
            <div>
              <h2 className="text-3xl font-bold text-gray-900 mb-4">WHO WE ARE</h2>
              <h3 className="text-xl text-gray-700 mb-6">
                Expert Auto Insurance Made Simple With SecureAuto Hub
              </h3>
              <p className="text-gray-600 leading-relaxed mb-6">
                Welcome to SecureAuto Hub, your premier source for clear, comprehensive auto insurance information and guidance. We believe that finding the right auto insurance shouldn't be complicated or overwhelming. That's why we've created a streamlined platform to educate, guide, and connect you with the best coverage options available.
              </p>
              <Link
                href="/about"
                className="text-blue-600 font-semibold hover:text-blue-800 inline-flex items-center"
              >
                Learn More About Us →
              </Link>
            </div>
            <div>
              <Image
                src="https://thumbs.dreamstime.com/b/happy-diverse-office-workers-team-laughing-together-group-meeting-cheerful-funny-joke-work-corporate-business-excited-smiling-141680673.jpg"
                alt="About Us - Professional team collaboration"
                width={500}
                height={350}
                className="rounded-lg w-full h-auto"
              />
            </div>
          </div>
        </div>
      </div>

      {/* Content Stream Section */}
      <div className="py-20 autopolicy-light-bg">
        <div className="max-w-6xl mx-auto px-4">
          <h2 className="text-3xl font-bold text-center text-gray-900 mb-12">Insurance Resources</h2>
          <div className="grid md:grid-cols-3 gap-8">
            {/* Card 1 */}
            <div className="bg-white rounded-lg shadow-md overflow-hidden">
              <Image
                src="https://cdn.prod.website-files.com/6335aa486cd6f6658bf12e74/6866d4bc2c8b6c84359d9855_cheapest-auto-insurance-long-island-1.jpg"
                alt="Complete Coverage Guide"
                width={400}
                height={250}
                className="w-full h-48 object-cover"
              />
              <div className="p-6">
                <h3 className="text-lg font-bold text-gray-900 mb-3">
                  COMPLETE COVERAGE GUIDE
                </h3>
                <p className="text-gray-600 mb-4">
                  Understanding your auto insurance options is essential for making informed decisions about your protection
                </p>
                <Link
                  href="/blog/complete-guide-auto-insurance-2025"
                  className="text-blue-600 font-medium hover:text-blue-800"
                >
                  Learn More
                </Link>
              </div>
            </div>

            {/* Card 2 */}
            <div className="bg-white rounded-lg shadow-md overflow-hidden">
              <Image
                src="https://static.vecteezy.com/system/resources/previews/046/849/081/non_2x/heavy-traffic-in-a-big-city-with-air-pollution-and-dust-health-problem-traffic-jam-concept-photo.jpg"
                alt="Driving Record Impact"
                width={400}
                height={250}
                className="w-full h-48 object-cover"
              />
              <div className="p-6">
                <h3 className="text-lg font-bold text-gray-900 mb-3">
                  DRIVING RECORD IMPACT
                </h3>
                <p className="text-gray-600 mb-4">
                  Your driving history plays a crucial role in determining your insurance premiums and coverage options
                </p>
                <Link
                  href="/blog/what-to-do-after-car-accident"
                  className="text-blue-600 font-medium hover:text-blue-800"
                >
                  Learn More
                </Link>
              </div>
            </div>

            {/* Card 3 */}
            <div className="bg-white rounded-lg shadow-md overflow-hidden">
              <Image
                src="https://thumbs.dreamstime.com/b/stacked-coins-rising-interest-rates-financial-planning-concept-generative-ai-315424619.jpg"
                alt="Financial Planning & Rates"
                width={400}
                height={250}
                className="w-full h-48 object-cover"
              />
              <div className="p-6">
                <h3 className="text-lg font-bold text-gray-900 mb-3">
                  FINANCIAL PLANNING & RATES
                </h3>
                <p className="text-gray-600 mb-4">
                  Smart financial planning and understanding rate factors can help you secure the best insurance value
                </p>
                <Link
                  href="/blog/lower-auto-insurance-premiums"
                  className="text-blue-600 font-medium hover:text-blue-800"
                >
                  Learn More
                </Link>
              </div>
            </div>
          </div>

          <div className="text-center mt-8">
            <Link
              href="/blog"
              className="bg-blue-600 text-white px-6 py-3 rounded-lg font-semibold hover:bg-blue-700 transition-colors"
            >
              View All Articles
            </Link>
          </div>
        </div>
      </div>

      {/* Features Section */}
      <div className="py-20 bg-white">
        <div className="max-w-6xl mx-auto px-4">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">
              Why Choose SecureAuto Hub?
            </h2>
            <p className="text-xl text-gray-600">
              We provide the tools and expertise you need to make informed insurance decisions
            </p>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div className="text-center">
              <div className="bg-blue-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                <span className="text-2xl">🧮</span>
              </div>
              <h3 className="text-lg font-semibold text-gray-900 mb-2">
                <Link href="/quote#calculator" className="hover:text-blue-600">
                  Insurance Calculator
                </Link>
              </h3>
              <p className="text-gray-600 text-sm">
                Get instant estimates with our interactive calculator
              </p>
            </div>

            <div className="text-center">
              <div className="bg-blue-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                <span className="text-2xl">📋</span>
              </div>
              <h3 className="text-lg font-semibold text-gray-900 mb-2">
                <Link href="/quote" className="hover:text-blue-600">
                  Free Quotes
                </Link>
              </h3>
              <p className="text-gray-600 text-sm">
                Compare personalized quotes from top insurers
              </p>
            </div>

            <div className="text-center">
              <div className="bg-blue-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                <span className="text-2xl">📚</span>
              </div>
              <h3 className="text-lg font-semibold text-gray-900 mb-2">
                <Link href="/blog" className="hover:text-blue-600">
                  Expert Guides
                </Link>
              </h3>
              <p className="text-gray-600 text-sm">
                Learn from our comprehensive insurance resources
              </p>
            </div>

            <div className="text-center">
              <div className="bg-blue-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                <span className="text-2xl">🤝</span>
              </div>
              <h3 className="text-lg font-semibold text-gray-900 mb-2">
                <Link href="/contact" className="hover:text-blue-600">
                  Expert Support
                </Link>
              </h3>
              <p className="text-gray-600 text-sm">
                Get personalized help from insurance professionals
              </p>
            </div>
          </div>
        </div>
      </div>

      {/* Footer */}
      <footer className="autopolicy-primary py-12">
        <div className="max-w-6xl mx-auto px-4">
          <div className="grid md:grid-cols-2 gap-8">
            <div>
              <h3 className="text-white text-lg font-bold mb-4">GET IN TOUCH</h3>
              <div className="text-white space-y-2">
                <p>2847 Innovation Drive #425</p>
                <p>Austin, TX 78749</p>
                <p>+1 (512) 555-0199</p>
                <p>hello@secureautohub.com</p>
              </div>
            </div>
            <div className="flex flex-wrap gap-4 text-white">
              <Link href="/" className="hover:text-gray-300">Home</Link>
              <Link href="/about" className="hover:text-gray-300">About Us</Link>
              <Link href="/faq" className="hover:text-gray-300">FAQ</Link>
              <Link href="/quote" className="hover:text-gray-300">Get Quote</Link>
              <Link href="/blog" className="hover:text-gray-300">Blog</Link>
              <Link href="/contact" className="hover:text-gray-300">Contact Us</Link>
              <Link href="/privacy" className="hover:text-gray-300">Privacy Policy</Link>
              <Link href="/terms" className="hover:text-gray-300">Terms of Service</Link>
              <Link href="/sitemap" className="hover:text-gray-300">Site Map</Link>
            </div>
          </div>
          <div className="border-t border-gray-600 mt-8 pt-8">
            <p className="text-white text-center">
              Copyright © SecureAuto Hub - 2025
            </p>
          </div>
        </div>
      </footer>
    </div>
  )
}
