import ContactForm from '@/components/ContactForm'
import { Metadata } from 'next'

export const metadata: Metadata = {
  title: 'Contact SecureAuto Hub - Get Expert Auto Insurance Help | Austin, TX',
  description: 'Contact SecureAuto Hub for expert auto insurance guidance. Call (512) 555-0199, email hello@secureautohub.com, or visit our Austin, TX office.',
  keywords: [
    'contact SecureAuto Hub',
    'auto insurance help Austin',
    'insurance experts contact',
    'auto insurance consultation',
    'insurance guidance Austin TX'
  ],
  openGraph: {
    title: 'Contact SecureAuto Hub - Expert Auto Insurance Help',
    description: 'Get in touch with our auto insurance experts for personalized guidance and free quotes.',
    type: 'website',
  },
}

export default function ContactPage() {
  const contactMethods = [
    {
      title: 'Phone',
      details: '+1 (512) 555-0199',
      description: 'Call us Monday-Friday, 8am-8pm CT',
      icon: '📞'
    },
    {
      title: 'Email',
      details: 'hello@secureautohub.com',
      description: 'We respond within 24 hours',
      icon: '✉️'
    },
    {
      title: 'Live Chat',
      details: 'Available on our website',
      description: 'Instant help Monday-Friday, 9am-6pm CT',
      icon: '💬'
    },
    {
      title: 'Office',
      details: '2847 Innovation Drive #425',
      description: 'Austin, TX 78749',
      icon: '📍'
    }
  ]

  return (
    <div className="min-h-screen bg-gray-50">
      {/* Hero Section */}
      <div className="bg-white">
        <div className="max-w-6xl mx-auto px-4 py-16">
          <div className="text-center mb-16">
            <h1 className="text-4xl font-bold text-gray-900 mb-4">
              Get in Touch
            </h1>
            <p className="text-xl text-gray-600 max-w-2xl mx-auto">
              Have questions about auto insurance? Our expert team is here to help you find the perfect coverage for your needs.
            </p>
          </div>

          {/* Contact Methods */}
          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8 mb-16">
            {contactMethods.map((method, index) => (
              <div key={index} className="text-center">
                <div className="bg-blue-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                  <span className="text-2xl">{method.icon}</span>
                </div>
                <h3 className="text-lg font-semibold text-gray-900 mb-2">{method.title}</h3>
                <p className="text-blue-600 font-medium mb-1">{method.details}</p>
                <p className="text-gray-500 text-sm">{method.description}</p>
              </div>
            ))}
          </div>

          {/* Contact Form and Info */}
          <div className="grid lg:grid-cols-2 gap-12">
            <div>
              <ContactForm title="Send us a Message" />
            </div>

            <div className="space-y-8">
              <div>
                <h3 className="text-2xl font-bold text-gray-900 mb-4">Why Choose SecureAuto Hub?</h3>
                <ul className="space-y-3 text-gray-600">
                  <li className="flex items-start">
                    <span className="text-green-500 mr-2">✓</span>
                    Expert guidance from licensed insurance professionals
                  </li>
                  <li className="flex items-start">
                    <span className="text-green-500 mr-2">✓</span>
                    Compare quotes from 50+ top insurance providers
                  </li>
                  <li className="flex items-start">
                    <span className="text-green-500 mr-2">✓</span>
                    No hidden fees or surprise charges
                  </li>
                  <li className="flex items-start">
                    <span className="text-green-500 mr-2">✓</span>
                    24/7 customer support and claims assistance
                  </li>
                  <li className="flex items-start">
                    <span className="text-green-500 mr-2">✓</span>
                    Free quotes with no obligation to purchase
                  </li>
                </ul>
              </div>

              <div className="bg-blue-50 rounded-lg p-6">
                <h4 className="text-lg font-semibold text-gray-900 mb-3">Business Hours</h4>
                <div className="space-y-2 text-gray-600">
                  <div className="flex justify-between">
                    <span>Monday - Friday:</span>
                    <span>8:00 AM - 8:00 PM CT</span>
                  </div>
                  <div className="flex justify-between">
                    <span>Saturday:</span>
                    <span>9:00 AM - 5:00 PM CT</span>
                  </div>
                  <div className="flex justify-between">
                    <span>Sunday:</span>
                    <span>10:00 AM - 4:00 PM CT</span>
                  </div>
                  <div className="flex justify-between">
                    <span>Emergency Claims:</span>
                    <span>24/7 Available</span>
                  </div>
                </div>
              </div>

              <div>
                <h4 className="text-lg font-semibold text-gray-900 mb-3">Quick Response Guarantee</h4>
                <p className="text-gray-600">
                  We understand that insurance questions can't always wait. That's why we guarantee:
                </p>
                <ul className="mt-3 space-y-2 text-gray-600">
                  <li>• Phone calls answered within 3 rings during business hours</li>
                  <li>• Email responses within 24 hours</li>
                  <li>• Live chat responses within 2 minutes</li>
                  <li>• Emergency claims support available 24/7</li>
                </ul>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  )
}
